<?php
/* @var $fakturyVat Faktury[] */
/* @var $fakturyKoszt Faktury[] */
/* @var $this MainController */

/*
 * @property double $id
 * @property double $idFirmy
 * @property double $idKontrahenta
 * @property string $opis
 * @property string $dataWystawienia
 * @property string $dataPlatnosci
 * @property string $nrFaktury
 * @property double $cenaNetto
 * @property double $stawkaVat
 * @property string $czyKoszt
 */
?>

<style type="text/css">
	#financesTabs, #financesTabs-1, #financesTabs-2, #financesTabs-3 {
-webkit-box-sizing: border-box;
   -moz-box-sizing: border-box;
    -ms-box-sizing: border-box;
     -o-box-sizing: border-box;
        box-sizing: border-box;
	}
	#financesTabs-1, #financesTabs-2, #financesTabs-3 {
		height: 95.4%;
		overflow: auto;
	}
	div#laptopTheContainer {
		overflow: hidden;
	}
</style>

	<div id="financesTabs" style="margin:5px;height:98.5%;font-size:110%">
		<ul>
			<li><a href="#financesTabs-1">Faktury VAT</a></li>
			<li><a href="#financesTabs-2">Faktury kosztowe</a></li>
			<li><a href="#financesTabs-3">Noty księgowe</a></li>
		</ul>
		<div id="financesTabs-1">
			<table class="myFilesTable" style="width:100%">
				<thead>
					<tr>
						<th>Opis</th>
						<th>Kontrahent</th>
					</tr>
				</thead>
				<tbody>
					<?php foreach($fakturyVat as $faktura): ?>
					<tr <?php if (empty($faktura->dataPlatnosci)) echo 'style="rejected"'; ?>>
						<td style="font-size:large"><?php echo CHtml::link($faktura->opis,
							$this->createUrl('invoice', array('id'=>$faktura->id)),
							array('target'=>'_blank')); ?>
					</td>
					<td><?php echo $faktura->kontrahent->nazwa; ?></td>
					</tr>
					<tr>
						<td colspan="2" style="font-size:x-small;padding-bottom:10px">
							<span style="color:silver">Kwota:</span> <?php echo $faktura->cenaNettoCurrency; ?> (<?php echo $faktura->cenaBruttoCurrency; ?>)
							<span style="color:silver">Nr:</span> <?php echo $faktura->nrFaktury; ?>
							<span style="color:silver">Wystawiona:</span> <?php echo $faktura->dataWystawieniaYmd ?>
							<?php if (!empty($faktura->dataPlatnosciYmd)) echo '<span style="color:silver">Zapłacona:</span> ' . $faktura->dataPlatnosciYmd ?>
						</td>
					</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
		</div>
		<div id="financesTabs-2">
			<table class="myFilesTable" style="width:100%">
				<thead
					<tr>
						<th>Opis</th>
						<th>Kontrahent</th>
					</tr>
				</thead>
				<tbody>
					<?php foreach($fakturyKoszt as $faktura): ?>
					<tr <?php if (empty($faktura->dataPlatnosci)) echo 'style="rejected"'; ?>>
						<td style="font-size:large"><?php echo CHtml::link($faktura->opis,
							$this->createUrl('invoice', array('id'=>$faktura->id)),
							array('target'=>'_blank')); ?>
					</td>
					<td><?php echo $faktura->kontrahent->nazwa; ?></td>
					</tr>
					<tr>
						<td colspan="2" style="font-size:x-small;padding-bottom:10px">
							<span style="color:silver">Kwota:</span> <?php echo $faktura->cenaNettoCurrency; ?> (<?php echo $faktura->cenaBruttoCurrency; ?>)
							<span style="color:silver">Nr:</span> <?php echo $faktura->nrFaktury; ?>
							<span style="color:silver">Wystawiona:</span> <?php echo $faktura->dataWystawieniaYmd ?>
							<?php if (!empty($faktura->dataPlatnosciYmd)) echo '<span style="color:silver">Zapłacona:</span> ' . $faktura->dataPlatnosciYmd ?>
						</td>
					</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
		</div>
		<div id="financesTabs-3">
			<table class="myFilesTable" style="width:100%">
				<thead
					<tr>
						<th>Kontrahent</th>
						<th>Zlecenie</th>
						<th>Kara zł</th>
						<th>Data</th>
					</tr>
				</thead>
				<tbody>
					<?php foreach($bookNotes as $bookNote): ?>
					<tr>
						<td><?php echo $bookNote->kontrahent->nazwa; ?></td>
						<td>
							<a target="_blank" href="<?php echo $this->createUrl('/student/main/bookNote', array('id'=>$bookNote->id)); ?>">
								<?php echo $bookNote->nrUmowy . ' ' . $bookNote->idZlecenia0->dziedzina->nazwa . ' - ' . strtolower($bookNote->idZlecenia0->poziomStr) . ' - ' . $bookNote->idZlecenia0->kategoria; ?>
							</a>
						</td>
						<td><?php echo number_format($bookNote->idZlecenia0->kwotaKary, 2, ',', ' '); ?></td>
						<td><?php echo $bookNote->czasPodjeciaYmd; ?></td>
					</tr>
					<?php endforeach; ?>
					<?php foreach($bookNotesNew as $bookNote): ?>
					<tr>
						<td><?php echo $bookNote['nazwa']; ?></td>
						<td>
							<a target="_blank" href="<?php echo $this->createUrl('/student/main/bookNote', array('id'=>$bookNote['id'])); ?>">
								<?php echo $bookNote['zlecenie']; ?>
							</a>
						</td>
						<td><?php echo number_format(abs(floatval($bookNote['kwotaKary'])), 2, ',', ' '); ?></td>
						<td><?php echo $bookNote['czasZakonczenia']; ?></td>
					</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
		</div>
	</div>

<script type="text/javascript">
	$('#financesTabs').tabs();
</script>
